using System;

namespace transfuzija_krvi
{
    struct Kombinacija
    {
        public string[] resenje;
        public bool nemoguce;
        public Kombinacija(string[] resenje, bool nemoguce)
        {
            this.resenje = resenje;
            this.nemoguce = nemoguce;
        }
    }
     struct Transfuzija
    {
        public string grupa;
        public int br;
        public Transfuzija(string grupa, int br)
        {
            this.grupa = grupa;
            this.br = br;
        }
    }
    class Program
    {
        static Kombinacija varijacije(Kombinacija k, int n, Transfuzija[] transfuzije, int o, int a, int b, int ab)
        {
            if(o < 0 || a < 0 || b < 0 || ab < 0)
            { k.nemoguce = true; return k; }
            if (n == transfuzije.Length)
                return k;
            int br = transfuzije[n].br;
            if(transfuzije[n].grupa == "O")
            {
                k.resenje[n] = br + " 0 0 0";
                return varijacije(k, n + 1, transfuzije, o-br, a, b, ab); //jedino racvanje za O
            }
            if(transfuzije[n].grupa =="A") //jedno racvanje za A
            {
                if(a >= br)
                {
                    k.resenje[n] = "0 " + br + " 0 0";
                    return varijacije(k, n + 1, transfuzije, o, a - br, b, ab);
                }
                else
                {
                    k.resenje[n] = (br-a).ToString() + " " + a + " 0 0";
                    return varijacije(k, n + 1, transfuzije, o-br+a, 0, b, ab);
                }
            }
            if (transfuzije[n].grupa == "B") //jedno racvanje za B
            {
                if (b >= br)
                {
                    k.resenje[n] = "0 0 " + br + " 0";
                    return varijacije(k, n + 1, transfuzije, o, a, b - br, ab);
                }
                else
                {
                    k.resenje[n] = (br-b).ToString() +" 0 "+ b + " 0";
                    return varijacije(k, n + 1, transfuzije, o - br + b, a, 0, ab);
                }
            }
            if(transfuzije[n].grupa == "AB") //tri racvanja za AB - u slucaju da mora da oduzme resurse A ,B i O
            {
                if (ab >= br)
                {
                    k.resenje[n] = "0 0 0 " + br;
                    return varijacije(k, n + 1, transfuzije, o, a, b, ab - br);
                }
                if(o+ab >= br)  
                {
                    Kombinacija oduzmiodO = varijacije(k, n + 1, transfuzije, o-br+ab, a, b, 0);
                    if (!oduzmiodO.nemoguce)
                    {
                        k.resenje[n] = (br - ab).ToString() + " 0 0 " + ab;
                        return oduzmiodO;
                    }
                }
                Kombinacija oduzmiodA = varijacije(k, n + 1, transfuzije, o, a - (br - ab), b, 0);
                if (!oduzmiodA.nemoguce)
                {
                    k.resenje[n] = "0 " + (br - ab).ToString() + " 0 " + ab;
                    return oduzmiodA;
                }
                Kombinacija oduzmiodB = varijacije(k, n + 1, transfuzije, o, a, b - (br - ab), 0); 
                if(!oduzmiodB.nemoguce)
                {
                    k.resenje[n] = "0 0 " + (br - ab).ToString() + " " + ab; 
                    return oduzmiodB;
                }
                Kombinacija oduzmiodAiO;
                if (o >= a)
                    oduzmiodAiO = varijacije(k, n + 1, transfuzije, o - br + a + ab, 0, b, 0);
                else oduzmiodAiO = varijacije(k, n + 1, transfuzije, 0, a - br + o + ab, b, 0);
                if(!oduzmiodAiO.nemoguce)
                {
                    if(o >= a)
                        k.resenje[n] = (br-a-ab).ToString() + " " + a + " 0 " + ab;
                    else k.resenje[n] = o + " " + (br - o - ab).ToString() + " 0 " + ab;
                }
                Kombinacija oduzmiodBiO;
                if(o>=b)
                    oduzmiodBiO = varijacije(k, n + 1, transfuzije, o - br + b + ab, a, 0, 0);
                else oduzmiodBiO = varijacije(k, n + 1, transfuzije, 0, a, b - br + o + ab, 0);
                if (!oduzmiodBiO.nemoguce)
                {
                    if(o>=b)
                        k.resenje[n] = (br - b - ab).ToString() + " 0 " + b + " " + ab;
                    else k.resenje[n] = o + " 0 " + (br-o-ab).ToString() + " " + ab;
                }
                Kombinacija oduzmiodOsve;
                oduzmiodOsve = varijacije(k, n + 1, transfuzije, o - br + a + b + ab, 0, 0, 0);
                if (!oduzmiodOsve.nemoguce)
                {
                    k.resenje[n] = (br - a - b - ab).ToString() + " " + a + " " + b + " " + ab;
                    return oduzmiodOsve;
                }
                Kombinacija oduzmiodAsve;
                oduzmiodAsve = varijacije(k, n + 1, transfuzije, 0, a - br + o + b + ab, 0, 0);
                if(!oduzmiodAsve.nemoguce)
                {
                    k.resenje[n] = o + " " + (br - o - b - ab).ToString() + " " + b + " " + ab;
                    return oduzmiodAsve;
                }
                k.resenje[n] = o + " " + a + " " + (br - o - a - ab).ToString() + " " + ab;
                return varijacije(k, n + 1, transfuzije, 0, 0, b-br+o+a+ab, 0);
            }
            return k;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            string[] unos = Console.ReadLine().Split();
            int o = int.Parse(unos[0]);
            int a = int.Parse(unos[1]);
            int b = int.Parse(unos[2]);
            int ab = int.Parse(unos[3]);
            
            Kombinacija k = new Kombinacija(new string[n], false);
            Transfuzija[] transfuzije = new Transfuzija[n];
            for (int i = 0; i < n; i++)
            {
                string[] transfuzija = Console.ReadLine().Split();
                transfuzije[i] = new Transfuzija(transfuzija[0], int.Parse(transfuzija[1]));
            }
            if (varijacije(k, 0, transfuzije, o, a, b, ab).nemoguce)
                Console.WriteLine("nemoguce");
            else
            {
                Console.WriteLine("moguce");
                for (int i = 0; i < n; i++)
                    Console.WriteLine(k.resenje[i]);
            }

                
        }
    }
}